package listFW;

/**
 * Abstract factory to manufacture IEmptyList<E> and INEList<E>.
 * @author Dung X. Nguyen
 * @author Stephen B. Wong
 * @author Mathias Ricken - Copyright 2008 - All rights reserved.
 * @since Copyright 2004 - DXN, SBW All rights reserved
 * @stereotype factory
 */
public interface IListFactory<E> {
    /**
     * Creates an empty list.
     * @return an IMTList object.
     */
    public abstract IMTList<E> makeEmptyList();


    /**
     * Creates a non-empty list containing a given first and a given rest.
     * @param first a data object.
     * @param rest != null, the rest of the non-empty list to be manufactured.
     * @return an INEList object containing first and rest
     * @exception IllegalArgumentException if rest is null.
     */
    public abstract  INEList<E> makeNEList(E first, IList<? extends E> rest);
}