package listFW.visitor;

import listFW.*;

/**
 * Sums a IList<Integer> using a reverse accumulation (natural recursion) algorithm. 
 * @author Mathias Ricken - Copyright 2008 - All rights reserved.
 */
public class SumIntList implements IListAlgo<Integer,Integer, Object> {
    
    public Integer emptyCase(IMTList<? extends Integer> host, Object ... inp) {
        return 0;
    }
    public Integer nonEmptyCase(INEList<? extends Integer> host, Object ... inp) {
        return host.getFirst() + host.getRest().execute(this);
    }
}
