package listFW.visitor;

import listFW.*;

/**
 * Sums a IList<Integer> using a forward accumulation algorithm. 
 * Demonstrates that passing a non-parameterized value through a varargs is no problem.
 * @author Mathias Ricken - Copyright 2008 - All rights reserved.
 */
public class SumIntList_Fwd implements IListAlgo<Integer,Integer, Object> {
    
    public Integer emptyCase(IMTList<? extends Integer> host, Object ... inp) {
        return 0;
    }
    public Integer nonEmptyCase(INEList<? extends Integer> host, Object ... inp) {
        return  host.getRest().execute(helper, host.getFirst());
    }
    
    private IListAlgo<Integer,Integer, Integer> helper = new IListAlgo<Integer,Integer, Integer> (){    
        public Integer emptyCase(IMTList<? extends Integer> host, Integer ... acc) {
            return acc[0];
        }
        public Integer nonEmptyCase(INEList<? extends Integer> host, Integer ... acc) {
            return host.getRest().execute(this, host.getFirst() + acc[0]);
        }
    };
}
