package rac;

/**
 * Visitor on a RAC.
 * Since a RAC is a mutable data structure, we require an exact match for
 * the data type (IRAContainer<T>, not IRAContainer<? extends T>).
 * @author Mathias Ricken - Copyright 2008 - All rights reserved.
 */
public interface IRACVisitor<T,R,P> {
  public R emptyCase(IRAContainer<T> host, P... inp);
  public R nonEmptyCase(IRAContainer<T> host, P... inp);
}

  
