package rac;

import lrs.*;
import lrs.visitor.*;

import java.util.*;

/*
 * Implements a factory for restricted access containers that
 * return the ``highest priority'' item.
 * @author Mathias Ricken - Copyright 2008 - All rights reserved.
 */
public class PQComparatorRACFactory<T extends Comparable<T>> extends ALRSRACFactory<T> {
    private Comparator<T> _comp;

    /**
     * Used when the items in the container are Comparable objects.
     */
    public PQComparatorRACFactory() {
        _comp = new Comparator<T>() {
            public int compare(T x, T y) {
                /*
                 * Intentionally reverse the ordering so that the
                 * largest item will be first.
                 */
                return y.compareTo(x);
            }
        };
    }

    /**
     * Used when we want to prioritize the items according to a given Comparator.
     * @param comp the item that is smallest according to comp has the highest
     * priority.
     */
    public PQComparatorRACFactory(Comparator<T> comp) {
        _comp = comp;
    }

    /**
     * Create a container that returns the item with the highest priority
     * according to a given Comparator.
     */
    public IRAContainer<T> makeRAC() {
        return new LRSRAContainer<T>(new InsertInOrder<T>(_comp));
    }

}
