package rac;

import lrs.*;

/*
 * Implements a factory for restricted access containers, including a
 * container that returns a random item.
 * @author Mathias Ricken - Copyright 2008 - All rights reserved.
 */
public class RandomRACFactory<T> extends ALRSRACFactory<T> {
    /**
     * Create a container that returns a random item.
     */
    public IRAContainer<T> makeRAC() {
        return new LRSRAContainer<T>(new IAlgo<T,LRStruct<T>,T>() {
            public LRStruct<T> emptyCase(LRStruct<T> host, T... input) {
                return host.insertFront(input[0]);
            }
            
            public LRStruct<T> nonEmptyCase(LRStruct<T> host, T... input) {
                /*
                 * Math.Random returns a value between 0.0 and 1.0.
                 */
                if (0.5 > Math.random())
                    return host.insertFront(input[0]);
                else
                    return host.getRest().execute(this, input);
            }
        });
    }
}

