package fp;

import listFW.*;
import listFW.factory.*;

/**
 * Makes new NEList given a first and rest. Use binary lambda.
 * @author DXN
 * @author Mathias Ricken - Copyright 2008 - All rights reserved.
 */
public class Cons2<T> implements ILambda2<IList<T>,T,IList<T>> {
    IListFactory<T> _fac;
    public Cons2(IListFactory<T> fac) {
        _fac = fac;
    }
    /**
     * Creates an NEList with a given first and rest.
     * @param first the first element of the IList to be created.
     * @param rest an IList, the rest of the IList to be created.
     * @return IList
     */
    public IList<T> apply(T first, IList<T> rest) {
        return _fac.makeNEList(first, rest);
    }
}