package lrs.lazyLRSEvaluators;

import fp.*;
import lrs.*;

/**
 * Lazily creates a possibly infinite list that contains the pair-wise sums
 * of the elements in two provided source lists, given as two LRStructs.
 * If one of the lists ends, the created list will contain just the elements
 * in the other list. If both lists end, this list will end.
 */
public class LazyAddEval extends LazyCombineEval {
    // FOR STUDENT TO COMPLETE: add fields and methods here
    public LazyAddEval(LRStruct src1, LRStruct src2) {
        super(src1, src2, new ILambda() {
            public Object apply(Object[] param) {
                LRStruct src1 = (LRStruct)param[0];
                LRStruct src2 = (LRStruct)param[1];
                Integer i = (Integer)src1.removeFront();
                Integer j = (Integer)src2.removeFront();
                return i+j;
            }
        });
    }
}

