package lrs.lazyLRSEvaluators;

import lrs.*;
import fp.*;

public class LazyLambdaEval extends ALazyEval
{
    double n=0.0;
//  double fac = 1.0;  // alternative technique to storing ncoef
    double ncoef = 1.0; // alternative technique to storing nfac
    
    public final LRStruct nextLRS()
    {
        n++;
//    fac *= 2*n*(2*n+1);  // for sine
//    fac *= 2*n*(2*n-1);  // for cosine
        
        ncoef /= -2*n*(2*n+1); // for sine
//    ncoef /= -2*n*(2*n-1); // for cosine
        
        return makeLRS();
    }
    
    public final LRStruct makeLRS()
    {
        return makeLazyLRS ( new ILambda() {
            double power = 2*n+1; // for sine
//    double power = 2*n;  // for cosine
            
//      double coef = Math.pow(-1.0, n)/fac;  // if fac is stored
            
            double coef = ncoef;  // if ncoef is stored
            
            public Object apply(Object [] params) {
                return coef*Math.pow(Math.PI*((Number) params[0]).doubleValue(),power);
            }
            public String toString() {
                return coef+"*((PI*x)^"+power+")";
            }
        });
    }
}
