package lrs.visitor;
import lrs.*;
import logic.*;
// This visitor removes the node whose value matches the param's value.
// Returns true if remove was successful, returns false othewise.

public class RemoveItem implements IAlgo{
  public static RemoveItem Singleton = new RemoveItem();
  
  private RemoveItem(){
  }
  
  public Object emptyCase(LRStruct host, Object[] param) {
    return BooleanFactory.Singleton.makeBoolean(false);  // item not found.
  }
  
  public Object nonEmptyCase(final LRStruct host, final Object[] param) {
    //Integer item = (Integer) param[0];  // saves recasting all the time
    
    // Remove this node if the local data equals the param.
    return BooleanFactory.Singleton.makeBoolean(param[0].equals(host.getFirst())).
      execute( new IBooleanAlgo() {
      public Object trueCase(IBoolean h, Object[] inp) {;
        host.removeFront();
        return BooleanFactory.Singleton.makeBoolean(true);
      }
      public Object falseCase(IBoolean h, Object[] inp) {
        return host.getRest().execute(RemoveItem.this, param);
      }
    });
    
//    if (item.equals((Integer)host.getFirst()))
//    {
//      host.removeFront();
//      return new Boolean(true);
//    }
//    else   // otherwise recurse and return the result
//    {
//      return host.getRest().execute(this, param);
//    }
  }
}