package lrs.visitor;

import counter.*;
import lrs.*;

/**
 * Removes and returns the nth element in a LRS.
 */
public class RemoveNth implements IAlgo{
  
  public static RemoveNth Singleton = new RemoveNth();
  
  private RemoveNth(){}
  
  private static final ICounterAlgo counterAlgo = new ICounterAlgo() {
    /**
     * @param host 
     * @param param 
     * @return 
     */
    public Object zeroCase(ICounter host, Object[] param) {
      // param is the host of the null/nonNull cases.
      return (((LRStruct)param[0]).removeFront ());
    }
    
    /**
     * @param host 
     * @param param 
     * @return 
     */
    public Object nonZeroCase(ICounter host, Object[] param) {
      return (((LRStruct) param[0]).getRest ().execute (RemoveNth.Singleton, host.decrement ()));
    }
  };
  
  /**
   * @param host 
   * @param param 
   * @return 
   */
  public Object emptyCase(LRStruct host, Object[] param) {
    return (null); // No such element exists.
  }
  
  /**
   * @param host 
   * @param param 
   * @return 
   */
  public Object nonEmptyCase(LRStruct host, Object[] param) {
    return (((ICounter) param[0]).execute(counterAlgo, host)); //
  }  
}

