package lrs.visitor;

import lrs.*;
import logic.*;

/**
 * An algortihm on a LRStruct that will skip over all the leading multiples of the supplied value.
 * The return value is the sub-list (a LRStruct)  whose leading term is the first occurence of a
 * non-multiple of the given value.  Here the supplied value is assumed to be an Integer.
 */
public class SkipLeadMods implements IAlgo {
  public static SkipLeadMods Singleton = new SkipLeadMods();
  private SkipLeadMods(){}
  
  
  /**
   * No multiples to be found in the empty list, so the list is returned.
   * @param host 
   * @param param 
   * @return 
   */
  public Object emptyCase(LRStruct host, Object[] param)
  {
    return (host); // NYI 
  }
  
  /**
   * Recursively searches for the first non-multiple of the given value (in param).
   * @param host 
   * @param param 
   * @return 
   */
  public Object nonEmptyCase(final LRStruct host, final Object[] param)
  {
    return BooleanFactory.Singleton.makeBoolean(((Integer) host.getFirst()) > ((Integer) param[0])).
      execute( new IBooleanAlgo() {
      public Object trueCase(IBoolean h, Object[] inp) {;
        return (host);  // found the next one!
      }
      public Object falseCase(IBoolean h, Object[] inp) {
        return (host.getRest().execute (SkipLeadMods.this, param)); // keep looking, so recurse
      }
    });
    
//    if (((Integer) host.getFirst ()).intValue () % ((Integer)param[0]).intValue () != 0)
//    {
//      return (host);  // found the next one!
//    } 
//    else 
//    {
//      return (host.getRest().execute (this, param)); // keep looking, so recurse
//    } 
  }  
}

