 package listFW.visitor;

import listFW.*;

/**
 * Copies an IList<T> using the supplied IListFactory<T>
 * @author Mathias Ricken - Copyright 2008 - All rights reserved.
 */
public class CopyList2<T> implements IListAlgo<T,IList<T>, Void> {
    private IListFactory<T> fac;
    
    public CopyList2(IListFactory<T> fac) {
        this.fac = fac;
    }
    
    public IMTList<T> emptyCase(IMTList<? extends T> host, Void... nu) {
        return fac.makeEmptyList();
    }
    public INEList<T> nonEmptyCase(INEList<? extends T> host, Void... nu) {
        return fac.makeNEList( host.getFirst(), host.getRest().execute(this));
    }
}
