package listFW.visitor;

import fp.*;
import listFW.*;

/**
 * Folds a list, starting at the left side.
 * @param b[0] is the initial value.
 */
public class FoldL<T,P> implements IListAlgo<T,P,P> {
  private ILambda2<P,T,P> _f;
  /**
   * Constructor for a FoldL algorithm.
   * @param f a binary ILambda, i.e. one that takes two parameters as varargs.
   */
  public FoldL(ILambda2<P,T,P> f) {
    _f = f;
  }

  /**
   * Empty case. Return the initial value.
   * @param b b[0] is the initial value.
   * @return initial value
   */
  public P emptyCase(IMTList<? extends T> h, P... b) {
    return b[0];
  }
  
  /**
   * Non-empty case. Apply lambda to initial value and first, and recur.
   * @param b b[0] is the initial value.
   * @return result of folding
   */
  @SuppressWarnings("unchecked")
  public P nonEmptyCase(INEList<? extends T> h, P... b) {
    return h.getRest().execute(this, _f.apply(h.getFirst(), b[0]));
  }
  
}