package listFW;

/**
 * Abstract factory to manufacture IEmptyList and INEList.
 * @author Dung X. Nguyen
 * @author Stephen B. Wong
 * @since Copyright 2005 - DXN, SBW All rights reserved
 * @stereotype factory
 */
public interface IListFactory {
    /**
     * Creates an empty list.
     * @return an IMTList object.
     */
    public abstract IMTList makeEmptyList();


    /**
     * Creates a non-empty list containing a given first and a given rest.
     * @param first a data object.
     * @param tail != null, the rest of the non-empty list to be manufactured.
     * @return an INEList object containing first and tail
     * @exception IllegalArgumentException if tail is null.
     */
    public abstract INEList makeNEList(Object first, IList tail);
}