package lrs;

/**
 * Represents the empty state of a mutable list LRStruct. Uses the
 * Singleton pattern.
 * @author Dung X. Nguyen and Stephen Wong  Copyright 2005 - All rights reserved.
 * @author Mathias Ricken - Copyright 2008 - All rights reserved.
 * @since 8/25/05
 */
class EmptyNode<T> extends ANode<T> {
    /**
     * Throws java.util.NoSuchElementException.
     */
    LRStruct<T> getRest(LRStruct<T> owner) {
        throw new java.util.NoSuchElementException ("Empty list has no first.");
    }

    /**
     * Throws java.util.NoSuchElementException.
     */
    T getFirst(LRStruct<T> owner) {
        throw new java.util.NoSuchElementException ("Empty list has no first.");
    }

    /**
     * Throws java.util.NoSuchElementException.
     */
    LRStruct<T> setRest(LRStruct<T> tail, LRStruct<T> owner) {
        throw new java.util.NoSuchElementException ("Empty list has no tail.");
    }

    /**
     * Throws java.util.NoSuchElementException.
     */
    LRStruct<T> setFirst(T dat, LRStruct<T> owner) {
        throw new java.util.NoSuchElementException ("Empty list has no first.");
    }

    /**
     * The owner becomes non-empty and has dat as its first element.
     */
    LRStruct<T> insertFront(T dat, LRStruct<T> owner) {
        return owner.setHead(new NENode<T>(dat, new LRStruct<T>(this)));
    }

    /**
     * Throws java.util.NoSuchElementException.
     */
    T removeFront(LRStruct<T> owner) {
        throw new java.util.NoSuchElementException ("Empty list has no front.");
    }

    /**
    * Calls the <code>IAlgo</code> visitor's empty case.
    */
    <R,P> R execute(LRStruct<T> owner, IAlgo<T, R, P> algo, P ... inp) {
        return algo.emptyCase(owner, inp);
    }
}

