package lrs;

/**
 * Represents the non-empty state of a LStruct.
 * @author Dung X. Nguyen and Stephen Wong  Copyright 2005 - All rights reserved.
 * @author Mathias Ricken - Copyright 2008 - All rights reserved.
 * @since 8/25/05
 */
class NENode<T> extends ANode<T> {
    private T _dat;
    private LRStruct<T> _tail;
    
    /**
     * Initializes this NENode to contain dat and a given tail list.
     * @param dat the data object to be stored in this NENode.
     * @param tail the LRStruct tail of this NENode.
     */
    NENode(T dat, LRStruct<T> tail) {
        _dat = dat;
        _tail = tail;
    }
    
    LRStruct<T> getRest(LRStruct<T> owner) {
        return _tail;
    }
    
    T getFirst(LRStruct<T> owner) {
        return _dat;
    }
    
    LRStruct<T> setRest(LRStruct<T> tail, LRStruct<T> owner) {
        _tail = tail;
        return owner;
    }
    
    LRStruct<T> setFirst(T first, LRStruct<T> owner) {
        _dat = first;
        return owner;
    }
    
    /**
     * Inserts a data object at the front of the LRStruct owner.
     * @param dat the object to be inserted at the front.
     * @param owner the LRS referencing this NENode.
     */
    LRStruct<T> insertFront(T dat, LRStruct<T> owner) {
        return owner.setHead(new NENode<T>(dat, new LRStruct<T>(this)));
        /* Details:
         // LRStruct coOwner = new LRStruct (this);
         // NENode newNode = new NENode (dat, coOwner);
         // owner.setHead (newNode);
         // "old" style: owner._head = newNode - cannot be done here.
         */
    }
    
    T removeFront(LRStruct<T> owner) {
        owner.setHead(_tail.getHead()); // owner._head = _tail._head
        return _dat;
    }
    
    /**
     * Calls the visitor's non-empty case.
     */
    <R,P> R execute(LRStruct<T> owner, IAlgo<T, R, P> algo, P ... input) {
        return algo.nonEmptyCase(owner, input);
    }
}

