package rac.test;

import rac.*;
import rac.visitor.*;

import junit.framework.TestCase;

/**
 * Test case of IsEmpty.
 * @author Mathias Ricken - Copyright 2008 - All rights reserved.
 */
public class Test_IsEmpty extends TestCase {

  public void test_RAC() {
    IRACFactory<String> racFac = new LRSStackFactory<String>();
    IRAContainer<String> rac = racFac.makeRAC();
    IsEmpty<String> isEmpty = new IsEmpty<String>();
    
    assertEquals("Empty RAC:", Boolean.TRUE, rac.execute(isEmpty));
    
    rac.put("abc");
    assertEquals("Non-empty RAC:", Boolean.FALSE, rac.execute(isEmpty));
    
    rac.put("def");
    assertEquals("Non-empty RAC:", Boolean.FALSE, rac.execute(isEmpty));

    rac.get();
    assertEquals("Non-empty RAC:", Boolean.FALSE, rac.execute(isEmpty));
    
    rac.get();
    assertEquals("Empty RAC:", Boolean.TRUE, rac.execute(isEmpty));
  }
  
}
