package brs.visitor;
import brs.*;
import fp.*;
/**
 * Traverse a binary tree in order:
 * For an empty tree:
 * do the appropriate processing.
 * For a non-empty tree:
 * Traverse the left subtree in order;
 * Process the root;
 * Traverse the right subtree in order;
 * 
 * Uses one lambda as variant.
 * Let f be an ILambda and b be some input object.
 * empty case: 
 *   InOrder1(empty, f, b) = b;
 * non-empty case: 
 *   InOder(tree, f, b) = f(InOrder1(tree.left, f, b), tree, InOrder1(tree.right, f, b));
 * @author DXN
 * @author SBW
 * @since 09/22/2004
 */
public class InOrder1 implements IVisitor {
    private ILambda _f;
    public InOrder1(ILambda f) {
        _f = f;
    }
    public Object emptyCase(BiTree host, Object b) {
        return b; 
    }
    public Object nonEmptyCase(BiTree host, Object b) {
        return _f.apply(host.getLeftSubTree().execute(this, b), 
                        host,
                        host.getRightSubTree().execute(this, b));
    }
}