package brs.visitor.traverse.test;

import brs.*;
import brs.visitor.*;
import brs.visitor.traverse.*;
import listFW.*;
import listFW.visitor.*;
import listFW.factory.*;
import fp.*;

import junit.framework.TestCase;


public class Test_HigherOrderListInOrderRev extends TestCase {
    private static IListFactory lf = CompositeListFactory.Singleton;
    private static IVisitor lio = new InOrder1(new HigherOrderListInOrderRev(lf));
    
    /**
     */
    public void testEmptyCase() {
        BiTree bt = new BiTree();
        IList result = (IMTList)bt.execute(lio, lf.makeEmptyList());
        assertEquals("HigherOrderListInOrderRev for empty tree:", "()", result.toString());
    }

    /**
     */
    public void testNECase() {
        BiTree bt = new BiTree();        
        bt.insertRoot(5);
        IList L = (INEList)bt.execute(lio, lf.makeEmptyList());
        System.out.println(bt + "\nIn Order List is:\n"+ L + '\n');        
        assertEquals("HigherOrderListInOrderRev for non-empty tree:", "(5)", L.toString());

        bt.getLeftSubTree().insertRoot(-2);
        L = (INEList)bt.execute(lio, lf.makeEmptyList());
        System.out.println(bt + "\nIn Order List is:\n"+ L + '\n');        
        assertEquals("HigherOrderListInOrderRev for non-empty tree:", "(-2, 5)", L.toString());

        bt.getRightSubTree().insertRoot(10);
        L = (INEList)bt.execute(lio, lf.makeEmptyList());
        System.out.println(bt + "\nIn Order List is:\n"+ L + '\n');        
        assertEquals("HigherOrderListInOrderRev for non-empty tree:", "(-2, 5, 10)", L.toString());

        bt.getRightSubTree().getLeftSubTree().insertRoot(-9); 
        L = (INEList)bt.execute(lio, lf.makeEmptyList());
        System.out.println(bt + "\nIn Order List is:\n"+ L + '\n');        
        assertEquals("HigherOrderListInOrderRev for non-empty tree:", "(-2, 5, -9, 10)", L.toString());

        bt = new BiTree();
        bt.insertRoot(5);
        bt.getRightSubTree().insertRoot(-2);
        L = (INEList)bt.execute(lio, lf.makeEmptyList());
        System.out.println(bt + "\nIn Order List is:\n"+ L + '\n');        
        assertEquals("ListInOrder for non-empty tree:", "(5, -2)", L.toString());

    }
}
