package listFW.visitor;
import listFW.*;
import fp.*;
/**
 * Visitor to perform the fold-left operation on an IList
 */
public class FoldlIList implements IListAlgo {
  private ILambda _f;
  
  public FoldlIList(ILambda f) {
    _f = f;
  }
  // empty case: return base case
  public Object emptyCase(IMTList h, Object b) {
    return b;
  }
  // non-empty case: recur with fwd accumulation 
  public Object nonEmptyCase(INEList h, Object b) {
    return h.getRest().execute(this, _f.apply(h.getFirst(), b));
  }
}
