package listFW.visitor;
import listFW.*;
import fp.*;

/**
 * Visitor to perform the fold-right operation on an IList
 */
public class FoldrIList implements IListAlgo {
  private ILambda _f;
  
  public FoldrIList(ILambda f) {
    _f = f;
  }
  // empty case: return base case
  public Object emptyCase(IMTList h, Object b) {
    return b;
  }
  // non-empty case: recur with reverse accumulation 
  public Object nonEmptyCase(INEList h, Object b) {
    return _f.apply(h.getFirst(), h.getRest().execute(this, b));
  }
}
