package listFW.visitor.fold.test;
import junit.framework.TestCase;

import listFW.*;
import listFW.visitor.fold.*;
import listFW.visitor.*;
import listFW.factory.*;
import fp.*;

/**
 * Concatenating two IList using Foldr and Cons.
 * @author DXN
 */
public class Test_Append extends TestCase {
    IListFactory fac = CompositeListFactory.Singleton;
    
    // TO DO:
    ILambda f = null;  // STUDENT TO COME UP WITH THE RIGHT lambda HERE
    IListAlgo algo = null;  // STUDENT TO COME UP WITH THE RIGHT Fold HERE
    
    IList L0 = fac.makeEmptyList();  // ()
    IList L1 = fac.makeNEList("a", L0); // (a)
    IList L2 = fac.makeNEList("b", L1); // (b, a)
    
    public void testEmpty() {
        assertEquals("Concat Empty list with Empty list", "()", L0.execute(algo, L0).toString());
        assertEquals("Concat Empty list with (a)", "(a)", L0.execute(algo, L1).toString());
        assertEquals("Concat Empty list with (b, a)", "(b, a)", L0.execute(algo, L2).toString());
    }
  
    public void testNonEmpty() {
        IList one = fac.makeNEList(1, L0);
        assertEquals("Concat (1) with Empty List", "(1)", one.execute(algo, L0).toString());
        IList two = fac.makeNEList(2, one);
        assertEquals("Concat (2, 1) with Empty List", "(2, 1)", two.execute(algo, L0).toString());
        assertEquals("Concat (1) with (a)", "(1, a)", one.execute(algo, L1).toString());
        assertEquals("Concat (2, 1) with (a)", "(2, 1, a)", two.execute(algo, L1).toString());
        assertEquals("Concat (1) with (b, a)", "(1, b, a)", one.execute(algo, L2).toString());
        assertEquals("Concat (2, 1) with (b, a)", "(2, 1, b, a)", two.execute(algo, L2).toString());
    }
}
