
package lrs.visitor;
import lrs.*;

/**
 * Removes the leading consecutive multiple of an integer from the host.
 */
public class RemLeadMods implements IAlgo {
 public static RemLeadMods Singleton = new RemLeadMods();
 private RemLeadMods(){ }

 /**
  * @param host 
  * @param param 
  * @return 
  */
 public Object nullCase(LRStruct host, Object param)
 {
  return (null); // Nothing to remove.
 }

 /**
  * Removes leading multiples of param from host.
  * @param host the LRS to filter.
  * @param param the factor to be filtered
  * @return 
  */
 public Object nonNullCase(LRStruct host, Object param)
 {
  if (((Integer) host.getFirst ()).intValue () % ((Integer)param).intValue () == 0)
  {
   host.removeFirst ();
   host.execute (this, param);
  } 
  return (host.getFirst ()); // 
 }

}

