package lrs.visitor;
import lrs.*;
// This visitor removes the node whose value matches the param's value.
// Returns true if remove was successful, returns false othewise.

public class RemoveItem implements IAlgo {
  public static RemoveItem Singleton = new RemoveItem();
  
  private RemoveItem()  { }
  
  public Object nullCase(LRStruct host, Object param)
  {
    return new Boolean(false);  // item not found.
  }
  
  public Object nonNullCase(LRStruct host, Object param)
  {
    Integer item = (Integer) param;  // saves recasting all the time
    
    // Remove this node if the local data equals the param.
    if (item.equals((Integer)host.getFirst()))
    {
      host.removeFirst();
      return new Boolean(true);
    }
    else   // otherwise recurse and return the result
    {
      return host.getRest().execute(this, param);
    }
  }

}