package lrs.visitor;

import lrs.*;

/**
 * An algortihm on a LRStruct that will skip over all the leading multiples of the supplied value.
 * The return value is the sub-list (a LRStruct)  whose leading term is the first occurence of a
 * non-multiple of the given value.  Here the supplied value is assumed to be an Integer.
 */
public class SkipLeadMods implements IAlgo
{
 public static SkipLeadMods Singleton = new SkipLeadMods();
 private SkipLeadMods(){ }


 /**
  * No multiples to be found in the empty list, so the list is returned.
  * @param host 
  * @param param 
  * @return 
  */
 public Object nullCase(LRStruct host, Object param)
 {
  return (host); // NYI 
 }

 /**
  * Recursively searches for the first non-multiple of the given value (in param).
  * @param host 
  * @param param 
  * @return 
  */
 public Object nonNullCase(LRStruct host, Object param)
 {
  if (((Integer) host.getFirst ()).intValue () % ((Integer)param).intValue () != 0)
  {
   return (host);  // found the next one!
  } 
  else 
  {
   return (host.getRest().execute (this, param)); // keep looking, so recurse
  } 
 }
}

