package poly.op;

import poly.IPolyOp;
import poly.IConstPoly;
import poly.INCPoly;

public class ToString implements IPolyOp {

    public static final ToString Singleton = new ToString();
    private ToString() {
    }

    public Object constCase(IConstPoly pol, Object... inp) {
        return Double.toString(pol.getLeadCoef());
    }

    public Object nonConstCase(INCPoly pol, Object... inp) {
        return pol.getLeadCoef() + "x^" + pol.getOrder() +
            pol.getLowerPoly().execute(new IPolyOp() {

                public Object constCase(IConstPoly p, Object... n) {
                    double c = p.getLeadCoef();
                    return (c < 0 || 0 < c)? " + " + c: "";  // Don't print a trailing zero
                }

                public Object nonConstCase(INCPoly p, Object... n) {
                    return " + " + p.getLeadCoef() + "x^" + p.getOrder() +
                        p.getLowerPoly().execute(this);
                }
            });
    }
}