package poly.op;

import poly.*;
import poly.factory.*;

/**
* Adds host polynomial to a constant.  Returns the resulting sum polynomial.
 * @author Dung X. Nguyen
 * @since Copyright 2002 - DXN - All rights reserved
*/
public class AddConst implements IPolyOp {

    IPolyFact _fact;

    public AddConst(IPolyFact f) {
        _fact = f;
    }

    /**
     * @param poly a constant polynomial
     * @param inp a Double
     * @return IConstPoly representing the sum of poly and inp.
     */
    public Object constCase (IConstPoly poly, Object... inp) {
        return _fact.makeConstPoly(poly.getLeadCoef() +
                                   ((Double)inp[0]).doubleValue ());
    }

    /**
     * @param poly a non-constant polynomial
     * @param inp a Double
     * @return INCPoly representing the sum of poly and inp.
     */
    public Object nonConstCase(INCPoly poly, Object... inp) {
        IPoly lowerSum = (IPoly)poly.getLowerPoly().execute (this, inp);
        return _fact.makeNCPoly(poly.getLeadCoef(), poly.getOrder(), lowerSum);
    }
}

