package poly.op;

import poly.*;

/**
 * Evaluates the host given a Double input using Horner's algorithm.
 * @author SBW, DXN
 */
public class EvalHorner implements IPolyOp {

    public static EvalHorner Singleton = new EvalHorner();
    private EvalHorner() {
    }

    /**
     * Returns the leading coefficient of this constant polynomial.
     * @param xVal[0] x value (Double)
     * @return Double
     */
    public Object constCase(IConstPoly pol, Object... xVal) {
        return pol.getLeadCoef();
    }

    /**
     * Asks the lower order polynomial for help, passing it this leading
     * coefficient of the host (a non-constant polynomial) as the accumulated
     * computed value so far, and the degree(i.e. order) of the host as the
     * degree of the enclosing polynomial.
     * @param xVal[0] x value (Double)
     * @return Double
     */
    public Object nonConstCase(INCPoly pol, Object... xVal) {
        final double x = (Double)xVal[0];
        return pol.getLowerPoly().execute(new IPolyOp() {

            public Object constCase(IConstPoly p, Object... inp) {
                double acc = (Double)inp[0];
                int prevOrder = (Integer) inp[1]; 
                return acc * Math.pow(x, prevOrder) + p.getLeadCoef();
            }

            public Object nonConstCase(INCPoly p, Object... inp) {
                double acc = (Double)inp[0];
                int prevOrder = (Integer) inp[1]; 
                int ord = p.getOrder();
                acc = acc * Math.pow(x, prevOrder - ord) + p.getLeadCoef();
                return p.getLowerPoly().execute(this, acc, ord);
            }
        }, pol.getLeadCoef(), pol.getOrder());
    }
}