package poly.op;

import poly.*;

/**
 * @author DXN
 */
public class Mul implements IPolyOp {

    private IPolyFact _fact;
    private IPolyOp _multMono;
    private IPolyOp _addOp;

    public Mul(IPolyFact f) {
        _fact = f;
        _multMono = new MultMono(f);
        _addOp = new AddOp(f);
    }

    public Object constCase(final IConstPoly pol, Object... q) {
        return ((IPoly)q[0]).execute(new IPolyOp() {

            public Object constCase (IConstPoly h, Object... nu) {
                return _fact.makeConstPoly(h.getLeadCoef() * pol.getLeadCoef());
            }

            public Object nonConstCase(INCPoly h, Object... nu) {
                return _fact.makeNCPoly(h.getLeadCoef() * pol.getLeadCoef(),
                                h.getOrder(),
                                (IPoly)h.getLowerPoly().execute (this));
            }
         }
         );
    }

    public Object nonConstCase(INCPoly pol, Object... q) {
        // Multiply q by the leading monomial of pol:
        IPoly p = (IPoly)((IPoly)q[0]).execute(_multMono, pol);
        return p.execute(_addOp, pol.getLowerPoly().execute(this, q));
    }
}


