package poly;

/**
 * Represents a polynomial of one variable.
 * @author Dung X. Nguyen
 * @since Copyright 2002 - DXN - All rights reserved
 * @dependency poly.IPolyOp accepts
 */
public interface IPoly {
    /**
     * Returns the leading coefficient of this IPoly.
     */
    public abstract double getLeadCoef();

    /**
     * Returns the order of this IPoly.
     */
    public abstract int getOrder();

    /**
     * Performs the operation op with a given input inp,and returns the result.
     */
    public abstract Object execute(IPolyOp op, Object[] inp);
}