package poly.op;

import poly.*;

/**
 * Holds the quotient/remainder pair in polynomial long division.
 */
public class QRPair {
    private IPoly _quotient;
    private IPoly _remainder;

    public QRPair(IPoly quotient, IPoly remainder) {
        _quotient = quotient;
        _remainder = remainder;
    }

    public final IPoly getQuotient() {
        return _quotient;
    }

    public final IPoly getRemainder() {
        return _remainder;
    }
}