package brs.visitor;
import brs.*;
import brs.visitor.traverse.*;
import listFW.*;

/**
 * Given an IListFactory, returns the IList containing the elements in the host
 * tree in in-order traversal.
 * @author Dung X. Nguyen - Copyright 2004 - All rights reserved.
 */
public class ListInOrder implements IVisitor {
    public static final ListInOrder Singleton = new ListInOrder();
    
    private ListInOrder() {}
    
    /**
     * @param lf ILIstFactory
    */
    public  Object emptyCase(BiTree host, Object lf) {
        return ((IListFactory)lf).makeEmptyList();
    }

    /**
    */
    public Object nonEmptyCase(BiTree host, Object lf) {
        final IListFactory fac = (IListFactory)lf;
        return host.execute(new IVisitor() {
            public Object emptyCase(BiTree h, Object acc) {
                return acc;
            }

            public Object nonEmptyCase(BiTree h, Object acc) {
                /*
                 * Construct the partial list consisting of the host and
                 * its right subtree.
                 */
                IList right = fac.makeNEList(h.getRootDat(),
                                        (IList)h.getRightSubTree().execute(this, acc));

                /*
                 * Pass the partial list to the left subtree and return
                 * the list given by the left subtree.
                 */
                return h.getLeftSubTree().execute(this, right);
            }
        }, fac.makeEmptyList());
    }

}

