package brs.visitor;
import brs.*;
import listFW.*;
import listFW.visitor.*;
import fp.*;


/**
 * Given an IListFactory, returns the IList containing the elements in the host
 * tree in in-order traversal.
 * @author Dung X. Nguyen - Copyright 2004 - All rights reserved.
 */
public class ListInOrderRev implements IVisitor {
    IListFactory _lf;
    IListAlgo _concat;
    
    public ListInOrderRev(IListFactory lf) {
        _lf = lf;
        _concat = new FoldrIList(new Cons(lf));
    }
    
    /**
    */
    public  Object emptyCase(BiTree host, Object nu) {
        return _lf.makeEmptyList();
    }

    /**
    */
    public Object nonEmptyCase(BiTree host, Object nu) {
        IList left = (IList)host.getLeftSubTree().execute(this, null);
        IList right = (IList)host.getRightSubTree().execute(this, null);
        IList acc = _lf.makeNEList(host.getRootDat(), right);
        return left.execute(_concat, acc);
    }

}

