package brs.visitor.test;

import brs.*;
import brs.visitor.*;
import brs.visitor.traverse.*;
import listFW.*;
import listFW.factory.*;

import junit.framework.TestCase;


public class Test_ListInOrderRev extends TestCase {
    private static IListFactory lf = CompositeListFactory.Singleton;
    private static IVisitor lio = new ListInOrderRev(lf);
    
    /**
     */
    public void testEmptyCase() {
        BiTree bt = new BiTree();
        IList result = (IMTList)bt.execute(lio, null);
        assertEquals("ListInOrderRev for empty tree:", "()", result.toString());
    }

    /**
     */
    public void testNECase() {
        BiTree bt = new BiTree();        
        bt.insertRoot(5);
        IList L = (INEList)bt.execute(lio, null);
        System.out.println(bt + "\nIn Order List is:\n"+ L + '\n');        
        assertEquals("ListInOrderRev for non-empty tree:", "(5)", L.toString());

        bt.getLeftSubTree().insertRoot(-2);
        L = (INEList)bt.execute(lio, null);
        System.out.println(bt + "\nIn Order List is:\n"+ L + '\n');        
        assertEquals("ListInOrderRev for non-empty tree:", "(-2, 5)", L.toString());

        bt.getRightSubTree().insertRoot(10);
        L = (INEList)bt.execute(lio, null);
        System.out.println(bt + "\nIn Order List is:\n"+ L + '\n');        
        assertEquals("ListInOrderRev for non-empty tree:", "(-2, 5, 10)", L.toString());

        bt.getRightSubTree().getLeftSubTree().insertRoot(-9); 
        L = (INEList)bt.execute(lio, null);
        System.out.println(bt + "\nIn Order List is:\n"+ L + '\n');        
        assertEquals("ListInOrderRev for non-empty tree:", "(-2, 5, -9, 10)", L.toString());

        bt = new BiTree();
        bt.insertRoot(5);
        bt.getRightSubTree().insertRoot(-2);
        L = (INEList)bt.execute(lio, null);
        System.out.println(bt + "\nIn Order List is:\n"+ L + '\n');        
        assertEquals("ListInOrderRev for non-empty tree:", "(5, -2)", L.toString());
    }
}
