package brs.visitor.traverse;
import brs.*;
import listFW.*;
import listFW.visitor.*;
import fp.*;


/**
 * Given an IListFactory, returns the IList containing the elements in the host
 * tree in in-order traversal.
 */
public class HigherOrderListInOrderRev implements ILambda {
    private IListFactory _lf;
    private IListAlgo _concat;  
    // STUDENT TO ADD APPROPRAITE FIELDS
    
    public HigherOrderListInOrderRev(IListFactory lf) {
        _lf = lf;
        _concat = new FoldrIList(new Cons(lf));    
    }
    
        /**
         * @param args[0] an IList
         * @param args[1] a BiTree
         * @param args[2] an IList
         */
        public Object apply(Object... args) {
            IList acc = _lf.makeNEList(((BiTree)args[1]).getRootDat(), (IList)args[2]);
            return ((IList)args[0]).execute(_concat, acc);
        }
}

