package lrs;
import java.awt.TextArea;
import java.awt.*;
/**
 * <<concrete state, Singleton>>
 * null LRS node
 */
class NullState
  extends AState                                                                                   
{
  public static final NullState Singleton = new NullState();
  private NullState(){ }
  
  
  /**
   * @param owner 
   * @return n
   */
  LRStruct getRest(LRStruct owner)
  {
    return(owner);
  }
  
  /**
   * @param owner 
   * @return n
   */
  Object getFirst(LRStruct owner)
  {
    return(null);
  }
  
  /**
   * @param tail 
   * @param owner 
   */
  void setRest(LRStruct tail, LRStruct owner)
  {
  }
  
  /**
   * @param dat 
   * @param owner 
   */
  void setFirst(Object dat, LRStruct owner)
  {
  }
  
  /**
   * @param dat 
   * @param owner 
   */
  void insertAsFirst(Object dat, LRStruct owner)
  {
    owner.setHead(new NonNullState(dat));
  }
  
  /**
   * @param owner 
   * @return 
   */
  Object removeFirst(LRStruct owner)
  {
    return(null);
  }
  
  Object execute(IAlgo visitor, Object param, LRStruct owner)
  {
    return visitor.nullCase(owner, param);
  }
  
}

