package lrs.visitor;
import lrs.*;

// This class is an IComparable compatible object that holds integer values.

public class CompareObject implements IComparable
{
    private int _value;

    // Construct the object with an integer value
    public CompareObject( int value)
    {
        _value = value;
    }
 
    // Construct the object with a string value
    public CompareObject( String strValue)
    {
        _value = Integer.parseInt(strValue);
    }

    // returns the integer value held as an integer
    public int getValue()
    {
        return _value;
    }

    // returns the integer value held as a string
    public String getString()
    {
        return String.valueOf(_value);
    }
    
    // Compare returns true if the object's value is less than the input value.
    public boolean compare(IComparable x)
    {
        return( (_value < ((CompareObject)x).getValue() )? true: false);
    }

    // Equals returns true if the object's value is equal to the input's value.
    public boolean equals(IComparable x)
    {
       return( (_value == ((CompareObject)x).getValue() )? true: false);
    }
}