package poly.op;

import poly.*;



public class Div implements IPolyOp {
  
  private IPolyFact _fact;
  private IPolyOp _mulOp;
  private IPolyOp _addOp;
  private IPoly _zero;
  
  public Div(IPolyFact f) {
    _fact = f;
    _mulOp = new MultMono(_fact);
    _addOp = new AddOp(_fact);
    _zero = _fact.makeConstPoly(0.0);
  }
  
  public Object constCase(final IConstPoly lhsHost, Object... rhs) {
    return ((IPoly)rhs[0]).execute(new IPolyOp() {
      /**
       * lhs = const & rhs = const
       */
      public Object constCase (IConstPoly rhsHost, Object... nu) {
        return _fact.makeConstPoly(lhsHost.getLeadCoef()/rhsHost.getLeadCoef());
      }
      
      /**
       * lhs = const & rhs != const
       */
      public Object nonConstCase(INCPoly p, Object... nu) {
        return _zero;
      }
    });
  }
  
  public Object nonConstCase(final INCPoly lhsHost, final Object... rhs) {
    
    return ((IPoly)rhs[0]).execute(new IPolyOp() {
      
      /**
       * lhs != const & rhs = const
       */
      public Object constCase(IConstPoly rhsHost, Object... nu) {
        return _fact.makeNCPoly(lhsHost.getLeadCoef()/rhsHost.getLeadCoef(), lhsHost.getOrder(), 
                                (IPoly)lhsHost.getLowerPoly().execute(Div.this, rhsHost));
      }
      
      /**
       * lhs != const & rhs != const
       */
      public Object nonConstCase(INCPoly rhsHost, Object... nu) {     
        int rhsOrder = rhsHost.getOrder();
        int lhsOrder = lhsHost.getOrder();
        
        if(rhsOrder > lhsOrder) {
          return _zero;
        }

        double resultCoef = lhsHost.getLeadCoef()/rhsHost.getLeadCoef();
                
        if(rhsOrder == lhsOrder) {
          return _fact.makeConstPoly(resultCoef);
        }
        
        // rhsOrder < lhsOrder
        int resultOrder = lhsOrder - rhsOrder; 
        IPoly factor = _fact.makeNCPoly(-resultCoef, resultOrder, _zero);
        IPoly temp = ((IPoly)rhsHost.getLowerPoly().execute(_mulOp, factor));
        IPoly reduced = (IPoly) lhsHost.getLowerPoly().execute(_addOp, temp);
        return _fact.makeNCPoly(resultCoef, resultOrder, 
                                (IPoly)reduced.execute(Div.this, rhsHost));
      }
    });
  }
}
                         
                        
     
