package poly.op;

import poly.*;
import poly.factory.*;

/**
 * Evaluates the host polynomial at a double input.  Returns a Double.
 * @author Dung X. Nguyen
 * @since Copyright 2002 - DXN - All rights reserved
*/
public class EvalOp implements IPolyOp {
    public final static EvalOp Singleton = new EvalOp ();

    private EvalOp() {
    }

    /**
     * @param poly
     * @param inp an Double
     * @return the constant Double value of poly.
     */
    public Object constCase(IConstPoly poly, Object... inp) {
        return new Double(poly.getLeadCoef());
    }

    /**
     * @param poly
     * @param inp an Double
     * @return the Double value of poly evaluated at inp.
     */
    public Object nonConstCase (INCPoly poly, Object... inp) {
        double x = ((Double)inp[0]).intValue();
        double leadVal = poly.getLeadCoef() * Math.pow (x, poly.getOrder());
        double lowerVal =
               ((Double)poly.getLowerPoly().execute(this, inp)).doubleValue();
        return new Double(leadVal + lowerVal);
    }
}

