package poly.test;
import poly.*;
import poly.op.*;
import poly.factory.*;

import junit.framework.TestCase;


public class Test_Poly extends TestCase {
  
  
  public void test_toString() {
    IPolyFact fac = CompPolyFact.Singleton;
    
    IPoly p = fac.makeConstPoly(0.0);
    assertEquals("Const poly", "0.0", p.toString());
    p = fac.makeNCPoly(3.14, 1, p);
    assertEquals("Order 1 poly", "3.14x^1", p.toString());
    p = fac.makeConstPoly(12.3);
    assertEquals("Const poly", "12.3", p.toString());
    p = fac.makeNCPoly(34.5, 1, p);
    assertEquals("Order 1 poly", "34.5x^1 + 12.3", p.toString());
    p = fac.makeNCPoly(5.67, 2, p);
    assertEquals("Order 2 poly", "5.67x^2 + 34.5x^1 + 12.3", p.toString());
    p = fac.makeNCPoly(7.89, 4, p);
    assertEquals("Order 4 poly", "7.89x^4 + 5.67x^2 + 34.5x^1 + 12.3", p.toString());    
  }
  
  
  public void test_EvalHorner() {
    IPolyFact fac = CompPolyFact.Singleton;
    
    IPolyOp algo = EvalHorner.Singleton;
    double x = 2.0;
    double c0 = 3.14;
    IPoly p = fac.makeConstPoly(c0);
    assertEquals("Const poly", c0, p.execute(algo, x));
    double c1 = 1.5;
    p = fac.makeNCPoly(c1, 1, p);
    assertEquals("Order 1 poly", c1*x+c0, p.execute(algo, x));
    double c2 = 2.3;
    p = fac.makeNCPoly(c2, 2, p);
    assertEquals("Order 2 poly", c2*Math.pow(x,2)+c1*x+c0, p.execute(algo, x));
    double c4 = 7.89;
    p = fac.makeNCPoly(c4, 4, p);
    assertEquals("Order 4 poly", c4*Math.pow(x, 4)+c2*Math.pow(x,2)+c1*x+c0, p.execute(algo, x));
    p = fac.makeNCPoly(c4, 4, fac.makeConstPoly(c0));
    assertEquals("Order 4 poly", c4*Math.pow(x, 4)+c0, p.execute(algo, x));
  }
  
}
