package poly;

/**
 * Abstract factory to manufacture IPoly objects.
 * @author Dung X. Nguyen
 * @since Copyright 2002 - DXN - All rights reserved
 * @dependency poly.IPoly instantiates
 */
public interface IPolyFact {

   /**
   * Creates a constant Polynomial with a given coefficient.
   */
    public abstract IConstPoly makeConstPoly(double coef);

   /**
   * Creates a non-constant polynomial with a given leading coefficient, a given
   * order, and a given lower order polynomial.
   * Checks for legal input parameters.
   * @param coef != 0.
   * @param order > 0.
   * @param lowPoly != null, the lower ordered polynomial with degree < order.
   * @exception IllegalArgumentException if conditions on coef, order and
   * lowerPoly are violated.
   */
    public abstract INCPoly makeNCPoly(double coef, int order, IPoly lowPoly);
}