package poly;

/**
 * Abstract polynomial operations as visitors to Polynomial.
 * @author Dung X. Nguyen
 * @since Copyright 2002, by Dung X. Nguyen, All rights reserved.
 * @dependency poly.IPoly visits
 */
public abstract interface IPolyOp {
    /**
     * Operates only on a constant polynomial with a given input.
     * @param pol a constant polynomial.
     * @param inp an input object needed by this IPolyOp.
     */
    public abstract Object constCase(IConstPoly pol, Object[] inp);

    /**
     * Operates only on a non-constant polynomial with a given input.
     * @param pol a non-constant polynomial.
     * @param in an input object needed by this IPolyOp.
     */
    public abstract Object nonConstCase(INCPoly pol, Object[] inp);
}

