package brs.test;

import junit.framework.TestCase;
import brs.*;
import brs.visitor.*;

/**
 * Tests LeafCount.
 */
public class TestLeafCount extends TestCase {
    static final IVisitor countLeaves = LeafCount.Singleton;

    public void test_emptyCase() {
        BiTree bt = new BiTree();
        int leafCount = (Integer)bt.execute(countLeaves, 0);
        System.out.println(bt + "\nLeaf Count:" + leafCount + '\n');
        assertEquals("Empty Tree leaf count", 0, leafCount);
    }
    
    public void test_nonEmptyCase() {
        BiTree bt = new BiTree();                
        bt.insertRoot(5);
        int leafCount = (Integer)bt.execute(countLeaves, 0);
        System.out.println(bt + "\nLeaf Count:" + leafCount + '\n');
        assertEquals("Non-empty Tree leaf count", 1, leafCount);
        
        bt.getLeftSubTree().insertRoot(-2);
        leafCount = (Integer)bt.execute(countLeaves, 0);
        System.out.println(bt + "\nLeaf Count:" + leafCount + '\n');
        assertEquals("Non-empty Tree leaf count", 1, leafCount);
        
        bt.getRightSubTree().insertRoot(10);
        leafCount = (Integer)bt.execute(countLeaves, 0);
        System.out.println(bt + "\nLeaf Count:" + leafCount + '\n');
        assertEquals("Non-empty Tree leaf count", 2, leafCount);
        
        bt.getRightSubTree().getLeftSubTree().insertRoot(-9);
        leafCount = (Integer)bt.execute(countLeaves, 0);
        System.out.println(bt + "\nLeaf Count:" + leafCount + '\n');
        assertEquals("Non-empty Tree leaf count", 2, leafCount);
        
        bt.getRightSubTree().getRightSubTree().insertRoot(7);
        leafCount = (Integer)bt.execute(countLeaves, 0);
        System.out.println(bt + "\nLeaf Count:" + leafCount + '\n');
        assertEquals("Non-empty Tree leaf count", 3, leafCount);
    }
}
