package brs.test;

import junit.framework.TestCase;
import brs.*;
import brs.visitor.*;
import fp.*;

/**
 * Constructs an in-order leaf counting visitor by composing the higher order 
 * visitor InOrder1 with an appropriate ILambda.
 * The student is to come up with the appropriate ILambda to do the job.
 * @author DXN (SOLUTION)
 */public class TestLeafCount1 extends TestCase {
    static final ILambda f = new ILambda() {  // SOLUTION
        /**
         * @param params[0], params[2] are Integer, param[1] BiTree
         */
        public Object apply(Object ... params) {
            return Add.Singleton.apply(params[0], Leaf.Singleton.apply(params[1]), params[2]);
        }
    };
    
    // Count the leaves in in-order:
    static final IVisitor countLeaves = new InOrder1(f);
    
    public void testEmpty() {
        BiTree bt = new BiTree();
        int leafCount = (Integer)bt.execute(countLeaves, 0);
        System.out.println(bt + "\nLeaf Count:" + leafCount + '\n');
        assertEquals("Empty Tree leaf count", 0, leafCount);
    }
    
    public void testNonEmpty() {
        
        BiTree bt = new BiTree();                
        bt.insertRoot(5);
        int leafCount = (Integer)bt.execute(countLeaves, 0);
        System.out.println(bt + "\nLeaf Count:" + leafCount + '\n');
        assertEquals("Non-empty Tree leaf count", 1, leafCount);
        
        bt.getLeftSubTree().insertRoot(-2);
        leafCount = (Integer)bt.execute(countLeaves, 0);
        System.out.println(bt + "\nLeaf Count:" + leafCount + '\n');
        assertEquals("Non-empty Tree leaf count", 1, leafCount);
        
        bt.getRightSubTree().insertRoot(10);
        leafCount = (Integer)bt.execute(countLeaves, 0);
        System.out.println(bt + "\nLeaf Count:" + leafCount + '\n');
        assertEquals("Non-empty Tree leaf count", 2, leafCount);
        
        bt.getRightSubTree().getLeftSubTree().insertRoot(-9);
        leafCount = (Integer)bt.execute(countLeaves, 0);
        System.out.println(bt + "\nLeaf Count:" + leafCount + '\n');
        assertEquals("Non-empty Tree leaf count", 2, leafCount);
        
        bt.getRightSubTree().getRightSubTree().insertRoot(7);
        leafCount = (Integer)bt.execute(countLeaves, 0);
        System.out.println(bt + "\nLeaf Count:" + leafCount + '\n');
        assertEquals("Non-empty Tree leaf count", 3, leafCount);
    }
}
