package brs.visitor;

import brs.*;
import rac.*;

/**
 * Prints the tree nodes in breadth traversal.
 * Uses a FIFO queue.
 * @author DXN
 */
public class BreadthPrint implements IVisitor {

    private IRAContainer _queue = new LRSQueueFactory().makeRAC();
    
    // IRAContainer visitor to go through the queue and process each tree
    // in the queus with a given BiTree visitor.
    private IRACVisitor _processQ = new IRACVisitor() {
        public Object emptyCase(IRAContainer q, Object treeVis) {
            return null;
        }
        public Object nonEmptyCase(IRAContainer q, Object treeVis) {
            ((BiTree)q.get()).execute((IVisitor)treeVis);
            return q.execute(this, treeVis);
        }
    };

    /**
     * Nothing to print here.
     */
    public Object emptyCase(BiTree host, Object... nu) {
        return null;
    }

    /**
     * Prints the root data, saves the left and right subtrees in _queue
     * and "process" _queue.
     */
    public Object nonEmptyCase(BiTree host, Object... nu) {
        _queue.put(host.getLeftSubTree());
        _queue.put(host.getRightSubTree());
        System.out.print(host.getRootDat());
        return _queue.execute(_processQ, new IVisitor() {
            public Object emptyCase(BiTree h, Object... nu) {
                return null;
            }
            public Object nonEmptyCase(final BiTree h, Object... nu) {
                _queue.put(h.getLeftSubTree());
                _queue.put(h.getRightSubTree());
                System.out.print(" " + h.getRootDat());
                return null;
            }
        });
    }
            
    /**
     * Simple test code.
     */
    public static void main(String[] args) {
        BiTree t0 = new BiTree();
        t0.insertRoot(new Integer(1));
        BiTree t1 = new BiTree();
        t1.insertRoot(new Integer(2));
        BiTree t2 = new BiTree();
        t2.insertRoot(new Integer(3));
        t0.setLeftSubTree(t1);
        t0.setRightSubTree(t2);
        t1.getLeftSubTree().insertRoot(new Integer(4));
        t1.getLeftSubTree().getRightSubTree().insertRoot(new Integer(6));
        t2.getRightSubTree().insertRoot(new Integer(5));
        t2.getRightSubTree().getLeftSubTree().insertRoot(new Integer(7));
        System.out.println("t0 is: \n" + t0 + "\n");
        System.out.println("Breadth first traversal:");
        t0.execute(new BreadthPrint());
        System.out.println("\nDone!");
    }
}