package brs.visitor;

import brs.*;
import fp.*;

/**
 * Traverse a binary tree in order:
 * For an empty tree:
 * do the appropriate processing.
 * For a non-empty tree:
 * Traverse the left subtree in order;
 * Process the root;
 * Traverse the right subtree in order;
 * 
 * Uses one lambda as variant.
 * Let f be an ILambda and b be some input object.
 * empty case: 
 *   InOrder1(empty, f, b) = b;
 * non-empty case: 
 *   InOder(tree, f, b) = f(InOrder1(tree.left, f, b), tree, InOrder1(tree.right, f, b));
 * @author DXN
 * @author SBW
 * @since 09/22/2005
 */
public class InOrder1 implements IVisitor {

    private ILambda _f;   

    public InOrder1(ILambda f) {
        _f = f;
    }

    public Object emptyCase(BiTree host, Object... b) {
        return b[0]; // IMPORTANT: DO NOT RETURN b!
    }

    public Object nonEmptyCase(BiTree host, Object... b) {
        return _f.apply(host.getLeftSubTree().execute(this, b), 
                        host,
                        host.getRightSubTree().execute(this, b));
    }
    
    public static void main(String[] nu) {
        final ILambda add = Add.Singleton;
        ILambda add3 = new ILambda() {
            public Object apply(Object ... params) {
                return add.apply(params[0], ((BiTree)params[1]).getRootDat(), params[2]);
            }
        };

        ILambda leafAdd = new ILambda() {
            public Object apply(Object ... params) {
                return add.apply(params[0], Leaf.Singleton.apply(params[1]), params[2]);
            }
        };

        // Counting leaves:
        IVisitor countLeaves = new InOrder1(leafAdd);

        // Add the numbers in the tree in in-order fashion:
        IVisitor inOrderAdd = new InOrder1(add3);
       
        final ILambda concat = new ILambda() {
            public Object apply(Object ... params) {
                if ("" != params[0].toString()) {
                    if ("" != params[1].toString()) {
                        return params[0].toString() + " " + params[1].toString();
                    }
                    else {
                        return params[0].toString();
                    }
                }
                else {
                    return params[1].toString();
                }
            }
        };

        ILambda concat3 = new ILambda() {
            public Object apply(Object ... params) {
                return concat.apply(concat.apply(params[0], ((BiTree)params[1]).getRootDat()), params[2]);
            }
        };        

        // Concatenate the String representation of the elements in the tree 
        // in in-order fashion:
        IVisitor inOrderConcat = new InOrder1(concat3);
       
        ILambda makeTree = new ILambda () {
            public Object apply(Object ... params) {
                BiTree result = new BiTree();
                result.insertRoot(((BiTree)params[1]).getRootDat());
                result.setLeftSubTree((BiTree)params[0]);
                result.setRightSubTree((BiTree)params[2]);
                return result;
            }
        };

        // Cloning a BiTree:
        IVisitor inOrderClone = new InOrder1(makeTree);
        
        ILambda makeMirror = new ILambda () {
            public Object apply(Object ... params) {
                BiTree result = new BiTree();
                result.insertRoot(((BiTree)params[1]).getRootDat());
                result.setLeftSubTree((BiTree)params[2]);
                result.setRightSubTree((BiTree)params[0]);
                return result;
            }
        };

        // Mirror immage of a BiTree:
        IVisitor inOrderMirror = new InOrder1(makeMirror);
              
        BiTree bt = new BiTree();
//        System.out.println(bt + "\nAdd \n" + bt.execute(inOrderAdd, 0));
//        System.out.println("In order concat \n" + bt.execute(inOrderConcat, ""));        
//        System.out.println("Cloning \n" + bt.execute(inOrderClone, new BiTree())); 
//        System.out.println("Mirror Tree \n" + bt.execute(inOrderMirror, new BiTree()) + '\n'); 
//        
//        bt.insertRoot(5);
//        System.out.println(bt + "\nAdd \n" + bt.execute(inOrderAdd, 0));
//        System.out.println("Cloning \n" + bt.execute(inOrderClone, new BiTree())); 
//        System.out.println("Mirror Tree \n" + bt.execute(inOrderMirror, new BiTree()) + '\n'); 
//        
//        bt.getLeftSubTree().insertRoot(-2);
//        System.out.println(bt + "\nAdd \n" + bt.execute(inOrderAdd, 0));
//        System.out.println("Cloning \n" + bt.execute(inOrderClone, new BiTree())); 
//        System.out.println("Mirror Tree \n" + bt.execute(inOrderMirror, new BiTree()) + '\n'); 
//        
//        bt.getRightSubTree().insertRoot(10);
//        System.out.println(bt + "\nAdd \n" + bt.execute(inOrderAdd, 0));
//        System.out.println("Cloning \n" + bt.execute(inOrderClone, new BiTree())); 
//        System.out.println("Mirror Tree \n" + bt.execute(inOrderMirror, new BiTree()) + '\n'); 
//      
//        bt.getRightSubTree().getLeftSubTree().insertRoot(-9);
//        System.out.println(bt + "\nAdd \n" + bt.execute(inOrderAdd, 0));
//        System.out.println("Cloning \n" + bt.execute(inOrderClone, new BiTree())); 
//        System.out.println("Mirror Tree \n" + bt.execute(inOrderMirror, new BiTree()) + '\n'); 
        System.out.println(bt + "\nLeaf Count: " + bt.execute(countLeaves, 0) + '\n');
                
        bt.insertRoot(5);
        System.out.println(bt + "\nLeaf Count: " + bt.execute(countLeaves, 0) + '\n');
        
        bt.getLeftSubTree().insertRoot(-2);
        System.out.println(bt + "\nLeaf Count: " + bt.execute(countLeaves, 0) + '\n');

        bt.getRightSubTree().insertRoot(10);
        System.out.println(bt + "\nLeaf Count: " + bt.execute(countLeaves, 0) + '\n');

        bt.getRightSubTree().getLeftSubTree().insertRoot(-9);
        System.out.println(bt + "\nLeaf Count: " + bt.execute(countLeaves, 0) + '\n');

        bt.getRightSubTree().getRightSubTree().insertRoot(7);
        System.out.println(bt + "\nLeaf Count: " + bt.execute(countLeaves, 0) + '\n');    
      
        System.out.println("Done!");
    }
}