package brs.visitor;

import brs.*;
import fp.*;

/**
 * Counts the leaves in a tree in in-order.
 * @author DXN - SOLUTION
 */
public class LeafCount implements IVisitor {

    public static final LeafCount Singleton = new LeafCount();    
    private LeafCount() {
    }

    public Object emptyCase(BiTree host, Object... nu) {
        return 0; 
    }
    public Object nonEmptyCase(BiTree host, Object... nu) {
        Integer left = (Integer)host.getLeftSubTree().execute(this);
        Integer root = (Integer)Leaf.Singleton.apply(host);
        Integer right = (Integer)host.getRightSubTree().execute(this);
        return left + root + right;
    }
}
