package fp;

/**
 * Adding two Integers
 * @author DXN
 */
public class Add implements ILambda {
    public static final Add Singleton = new Add();
    private Add() {
    }
    /**
     * Adds zero to many Integer.
     * @param params Integer[].
     * @return Integer
     */
    public Object apply(Object ... params) {
        // params is treated as Object[].
//  Integer[] p = (Integer[])params; // Not allowed in Java: Class Cast Exception!
        int sum = 0;
        // New Java 5.0 for loop:
        for (Object i: params) {
            sum += (Integer)i;  // auto-unboxing: ((Integer)i).intValue()
        }
//        Traditional for loop (works OK):
//        for(int i = 0; i < params.length; i++) {
//            sum += (Integer)params[i];
//        }
        return sum;  // auto-boxing: new Integer(sum)
    }
}
