package fp;
import brs.*;

/**
 * A leaf is a tree whose subtrees are all empty.
 * This visitor takes a non-empty binary tree as input and returns 1 if the input is
 * a leaf, 0 otherwise.
 * NO if statement allowed!
 * @author DXN
 */
public class Leaf implements ILambda {
    public static final Leaf Singleton = new Leaf();
    private Leaf() {
    }
    /**
     * @param tree[0] a non-empty BiTree.
     * @return 1 if tree[0] is a leaf, 0 otherwise.
     */
    public Object apply(Object ... tree) {
        final BiTree bt = (BiTree)tree[0];
        return bt.getLeftSubTree().execute(new IVisitor() {
            public  Object emptyCase(BiTree host, Object... inp){
                return bt.getRightSubTree().execute(new IVisitor() {
                    public Object emptyCase(BiTree host, Object... nu) {
                        return 1;
                    }
                                        
                    public  Object nonEmptyCase(BiTree host, Object... nu) {
                        return 0;
                    }
                });
            }
            
            public  Object nonEmptyCase(BiTree host, Object... nu) {
                return 0;
            }
        });
    }
}
